package book.beans;

import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.application.NavigationHandler;
import javax.faces.application.NavigationHandlerWrapper;
import javax.faces.context.FacesContext;

/**
 *
 * @author Leonard
 */
public class CustomScopeNavigationHandler extends NavigationHandlerWrapper {

    private static final Logger logger = Logger.getLogger(CustomScopeNavigationHandler.class.getName());
    private final NavigationHandler navigationHandler;

    public CustomScopeNavigationHandler(NavigationHandler navigationHandler) {         
        this.navigationHandler = navigationHandler;
    }   

    @Override
    public void handleNavigation(FacesContext context, String fromAction, String outcome) {

        if (outcome != null) {
            if (outcome.equals("sponsored")) {
                logger.log(Level.INFO, "Tworzenie zasięgu niestandardowego...");

                Map<String, Object> applicationMap = context.getExternalContext().getApplicationMap();
                CustomScope customScope = (CustomScope) applicationMap.get(CustomScope.SCOPE);

                if (customScope == null) {
                    customScope = new CustomScope();
                    applicationMap.put(CustomScope.SCOPE, customScope);

                    customScope.scopeCreated(context);
                } else {
                    logger.log(Level.INFO, "Zasięg niestandardowy już istnieje...");
                }
            } else {
                logger.log(Level.INFO, "Usuwanie zasięgu niestandardowego...");

                Map<String, Object> applicationMap = context.getExternalContext().getApplicationMap();
                CustomScope customScope = (CustomScope) applicationMap.get(CustomScope.SCOPE);

                if (customScope != null) {
                    customScope.scopeDestroyed(context);
                    applicationMap.remove(CustomScope.SCOPE);
                } else {
                    logger.log(Level.INFO, "Zasięg niestandardowy nie istnieje...");
                }
            }
        }

        getWrapped().handleNavigation(context, fromAction, outcome);
    }

    @Override
    public NavigationHandler getWrapped() {
        return navigationHandler;
    }
}
